/**
 Démo Sécurisation d'une application N Tiers
 * Couche métier EJB
 * Lécu Régis, 12/10/2016
 */
package javaeetutorial.cartsecure.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javaeetutorial.cartsecure.util.BookException;
import javaeetutorial.cartsecure.util.IdVerifier;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remove;
import javax.ejb.Stateful;


@Stateful
@DeclareRoles("RoleAdmin")                      // 2) ejb utilisé par le rôle de sécurité : TutorialUser
public class CartBean implements Cart, Serializable {

    String customerId;          // id du client 
    String customerName;
    List<String> contents;

    // 3) l'initialisation du panier par le client n'a pas de restriction
    @Override
    public void initialize(String person) throws BookException {
        if (person == null) {
            throw new BookException("Null person not allowed.");
        } else {
            customerName = person;
        }

    }

    @Override
    public void initialize(String person, String id) throws BookException {
        if (person == null) {
            throw new BookException("Null person not allowed.");
        } else {
            customerName = person;
        }

        IdVerifier idChecker = new IdVerifier();
        if (idChecker.validate(id)) {
            customerId = id;
        } else {
            throw new BookException("Invalid id: " + id);
        }

        contents = new ArrayList<>();
    }

    @Override
    @RolesAllowed ("RoleUser")
    public void addBook(String title) {
        contents.add(title);
    }

    // 4) toutes les autres méthodes métiers sont restreintes au rôle de sécurité TutorialUser
    @Override
    @RolesAllowed ("RoleUser")
    public void removeBook(String title) throws BookException {
        boolean result = contents.remove(title);

        if (result == false) {
            throw new BookException("\"" + title + "\" not in cart.");
        }
    }

    @Override
    @RolesAllowed ("RoleUser")
    public List<String> getContents() {
        return contents;
    }

  
    @Override
    @RolesAllowed ("RoleAdmin")
    public void remove() {
        System.out.println("***** Suppression complète du panier ********");
        contents = null;
    }
}
